### Next-Generation Firewall Services
- URL filtering
- Application control and visibility
- Advanced malware protection
- Intrusion Prevention System (IPS)
### Unified Platform Capabilities
- Combines Cisco Secure Firewall Threat Defense and ASA code
- Features include NAT, VPNs, etc.
## Management Platforms

##### Cisco Management Options
- Cisco Secure Firewall Management Center
- Cisco Defense Orchestrator (cloud-based)
- Local onboard device manager
##### Key Features
- Real-time contextual awareness
- Full-stack visibility
- Intelligent security automation
- API integration

## Deployment Modes

##### Firewall Modes
- **Routed Mode**: Default; provides Layer 3 connectivity.
- **Transparent Mode**: Acts as a Layer 2 firewall, not seen as a router hop.
##### IPS and IDS Modes
- **IPS Inline Mode**: Traffic must pass through IPS; no NAT because the interface pair has no IP addressing.
![[Pasted image 20250324222047.png]]

- **IDS Passive Mode**: Monitors traffic using SPAN/mirror port.
![[Pasted image 20250324222102.png]]

- **IDS Inline Tap Mode**: Inline physical deployment with passive monitoring. Useful for when you want to add FTD to your environment without affecting anything right away. 
![[Pasted image 20250324222118.png]]
![[Pasted image 20250331142904.png]

## Appliance Use Cases

##### Internet Edge Deployment
- Perimeter security and segregation
- High availability routed mode
##### Data Center Deployment
- High throughput, typically 10-Gbps and above
- Application inspection at Layer 7
##### Branch Office Deployment
- Replaces router; provides IPsec VPN functionality
- Typically routed firewall with high availability

## High Availability Features

##### Failover
- Two identical devices for redundancy
- Active/standby configuration
##### Clustering
- Multiple devices grouped for scalability and redundancy
- Supported on 3100, 4100, 4200, and 9300 platforms

## Virtualization

##### Multi-Instance Feature
- Introduced in software version 6.3
- Independent and fault-isolated instances
- Supported on 4100 and 9300 Series appliances
##### Benefits
- Guaranteed performance per instance
- Traffic processing isolation
- Independent management plane for each instance